/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.RoutingProcessEvent;
import apiipc.generated.events.RoutingProcessEventListener;
import apiipc.generated.sim.RoutingProcess;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingProcessEventRegistry
extends IPCEventRegistry {
    protected Set<RoutingProcessEventListener> globalListeners = new HashSet<RoutingProcessEventListener>();
    protected Map<String, Set<RoutingProcessEventListener>> specificObjectListeners = new HashMap<String, Set<RoutingProcessEventListener>>();

    public RoutingProcessEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "RoutingProcess";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        RoutingProcessEvent routingProcessEvent = null;
        if (string.equalsIgnoreCase("routeAdded")) {
            routingProcessEvent = new RoutingProcessEvent.RouteAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("routeRemoved")) {
            routingProcessEvent = new RoutingProcessEvent.RouteRemoved(iPCEventLTV);
        } else if (string.equalsIgnoreCase("networkAdded")) {
            routingProcessEvent = new RoutingProcessEvent.NetworkAdded(iPCEventLTV);
        } else if (string.equalsIgnoreCase("networkRemoved")) {
            routingProcessEvent = new RoutingProcessEvent.NetworkRemoved(iPCEventLTV);
        } else {
            return;
        }
        for (RoutingProcessEventListener object : this.globalListeners) {
            object.handleEvent(routingProcessEvent);
        }
        System.out.println("UUID = " + routingProcessEvent.objectUUID);
        Set<RoutingProcessEventListener> set = this.specificObjectListeners.get(routingProcessEvent.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                RoutingProcessEventListener routingProcessEventListener = (RoutingProcessEventListener)iterator.next();
                routingProcessEventListener.handleEvent(routingProcessEvent);
            }
        }
    }

    public void addListenerFiltered(RoutingProcessEventListener routingProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("routeAdded");
                this.register("routeRemoved");
                this.register("networkAdded");
                this.register("networkRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(routingProcessEventListener);
    }

    public void addSpecificListenerFiltered(RoutingProcessEventListener routingProcessEventListener, RoutingProcess routingProcess, List<String> list) throws IOException {
        UUID uUID = routingProcess.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<RoutingProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<RoutingProcessEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "routeAdded");
                this.register(uUID, "routeRemoved");
                this.register(uUID, "networkAdded");
                this.register(uUID, "networkRemoved");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(routingProcessEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(RoutingProcessEventListener routingProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("routeAdded");
                this.deregister("routeRemoved");
                this.deregister("networkAdded");
                this.deregister("networkRemoved");
                this.globalListeners.remove(routingProcessEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(RoutingProcessEventListener routingProcessEventListener, RoutingProcess routingProcess, List<String> list) throws IOException {
        UUID uUID = routingProcess.getObjectUUID();
        String string = uUID.toString();
        Set<RoutingProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "routeAdded");
                this.deregister(uUID, "routeRemoved");
                this.deregister(uUID, "networkAdded");
                this.deregister(uUID, "networkRemoved");
                set.remove(routingProcessEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(RoutingProcessEventListener routingProcessEventListener) throws IOException {
        this.addListenerFiltered(routingProcessEventListener, null);
    }

    public void addListener(RoutingProcessEventListener routingProcessEventListener, RoutingProcess routingProcess) throws IOException {
        this.addSpecificListenerFiltered(routingProcessEventListener, routingProcess, null);
    }

    public void removeListener(RoutingProcessEventListener routingProcessEventListener) throws IOException {
        this.removeListenerFiltered(routingProcessEventListener, null);
    }

    public void removeListener(RoutingProcessEventListener routingProcessEventListener, RoutingProcess routingProcess) throws IOException {
        this.removeSpecificListenerFiltered(routingProcessEventListener, routingProcess, null);
    }
}

